*************************************************************************************************************************
* Estimation of capital income and wealth consistent with National Accounts using capitalization method and imputations *
*************************************************************************************************************************


set more off
clear 

foreach pas of  global yearliste{
	global year=`pas'
	
	set seed 1025075792
* I) Organize the data
***************************	
	
	* Capital income and assets from National Accounts 
			import excel using "$param/NationalAccountsparam.xlsx",first clear sheet("statacapital") cellrange(A7:S71) 
			* Transform all parameters into global 
					foreach var of varlist _all {
						quiet sum `var' if year==${year}
						global `var'=r(mean)
					}
				
	* Load the data
		use year- ndecl pac age pension_irpp_foy rente_irpp_foy salchom_irpp_foy nonsal_foy rfon_irpp_foy rfin_int_irpp_foy rfin_int_bar_irpp_foy rfin_div_irpp_foy rfin_irpp_foy using  "$wfrev/rev${year}.dta",clear
		merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(nonsal_capital_cn)
		* Small adjustments
			* keep only taxable intesrest at the progressive schedule the  interet for comparabilty issues
			replace rfin_int_irpp_foy =rfin_int_bar_irpp_foy
			* capital component of business income at the household level
			bys idfoy: egen nonsal_capital_cn_foy=sum(nonsal_capital_cn)
			* Financial income and labor income
			if ${year}>1984 {
				gen rev_fin_irpp_foy=rfin_int_irpp_foy+rfin_div_irpp_foy
				gen rev_trav_irpp_foy=pension_irpp_foy+rente_irpp_foy+salchom_irpp_foy+nonsal_foy
			}
			if ${year}<=1984 {
				gen rev_fin_irpp_foy=rfin_irpp_foy
				gen rev_trav_irpp_foy=pension_irpp_foy+rente_irpp_foy+salchom_irpp_foy+nonsal_foy
			}
			gen rev_tot=rev_fin_irpp+rev_trav_irpp_foy+rfon_irpp_foy
			drop _merge nonsal_capital_cn rfin_int_bar_irpp_foy pension_irpp_foy rente_irpp_foy salchom_irpp_foy nonsal_foy
	
	tempfile table
	save "`table'",replace
	keep if idnum==1 
	sort idindiv

* II) Imputation based on housing and wealth surveys
*********************************************************
	* Imputation based on age groups*groups of financial income*groups of labor income
	* Wealth surveys 1986-2010 and housing surveys 1970-1992
	
	* II.A) Imputation of life insurance	
	**************************************
	
		* 1) Variables used for imputations
		
			* Age groups			
				capture drop q_age_pr
				gen q_age_pr = 1
				replace q_age_pr = 2 if age >30
				replace q_age_pr = 3 if age >39
				replace q_age_pr = 4 if age >49
				replace q_age_pr = 5 if age >54
				replace q_age_pr = 6 if age >60
				replace q_age_pr = 7 if age >65
				replace q_age_pr = 8 if age >70
			
			* Age.groups of financial income		
				gen u=uniform() if rev_fin_irpp_foy==0
				replace rev_fin_irpp_foy=u if rev_fin_irpp_foy==0

				gen pondvr=round(100*pondn) 
				bys year pac q_age_pr : cumul rev_fin_irpp_foy [w=pondvr], gen (p100)
				replace p100=p100*100
				gen q_age_fin   = 0 
				replace q_age_fin= 50   if p100 >=50 & p100 <75 & q_age_fin==0
				replace q_age_fin= 75   if p100 >=75 & p100 <90 & q_age_fin==0
				replace q_age_fin= 90   if p100 >=90 & p100 <95 & q_age_fin==0
				replace q_age_fin= 95   if p100 >=95 & p100 <99 & q_age_fin==0
				replace q_age_fin= 99   if p100 >=99 & q_age_fin==0
				drop p100 pondvr u
				* Adjusment for < 30 years old (they have almost nothing)
				replace q_age_fin=0 if q_age_pr==1 
				

			* Age.groups of financial income.groups of labor income.
				gen u=uniform() if rev_trav_irpp_foy==0
				replace rev_trav_irpp_foy=u if rev_trav_irpp_foy==0			
				
				gen pondvr=round(100*pondn) 		
				bys year pac q_age_pr q_age_fin : cumul rev_trav_irpp_foy [w=pondvr], gen (p100)
				replace p100=p100*100
				gen q_age_fin_lr  = 0
				replace q_age_fin_lr=25  if p100 >=25 & p100 <50 & q_age_fin_lr==0
				replace q_age_fin_lr= 50   if p100 >=50 & p100 <75 & q_age_fin_lr==0
				replace q_age_fin_lr= 75   if p100 >=75 & p100 <90 & q_age_fin_lr==0
				replace q_age_fin_lr= 90   if p100 >=90 & p100 <95 & q_age_fin_lr==0
				replace q_age_fin_lr= 95   if p100 >=95 & q_age_fin_lr==0
				drop p100 pondvr  u
				* Adjusments for the top 5% of financial income (not enough observation to split into different labor income groups)
				replace q_age_fin_lr= 0 if q_age_fin== 95 | q_age_fin== 99
		
		* 2) Merge imputations parameters of each groups
			if ${year}<1986 {
				tempfile temp
				save "`temp'"
				use "$param/Imputation/clef_life_EP.dta",clear
				keep if year==1986
				drop year
				tempfile cleftemp
				save "`cleftemp'",replace
				use "`temp'",clear
				merge m:1 q_age_pr q_age_fin q_age_fin_lr using "`cleftemp'"
				erase "`cleftemp'"
				erase "`temp'"
			}
			if ${year}>2010 {
				tempfile temp
				save "`temp'"
				use "$param/Imputation/clef_life_EP.dta",clear
				keep if year==2010
				drop year
				tempfile cleftemp
				save "`cleftemp'",replace
				use "`temp'",clear
				merge m:1 q_age_pr q_age_fin q_age_fin_lr using "`cleftemp'"
				erase "`cleftemp'"
				erase "`temp'"
			}
			if (${year}>=1986 & ${year}<=2010) {
				merge m:1 year q_age_pr q_age_fin q_age_fin_lr using "$param/Imputation/clef_life_EP.dta"
			}
			drop if _merge==2
			drop _merge
			
											
		* 3) Imputation of life insurance
			gen group=10000*q_age_pr+100* q_age_fin +q_age_fin_lr
			gen rfin_av_cn_foy=0
			gen patfin_av_cn_foy=0				
			gen owner_avie=0
			
			* Extensive margin: life-insurance ownership
				sort idfoy
				bys group: gen uni=runiform() if pac~=1
				gen pondvr=round(100*pondn) 
				sort group uni
				bys group : cumul uni [w=pondvr], gen (p100)			
				drop uni 
				replace owner_avie=1 if prop_avie>=p100								
				
			* Intensive margin: Amount of life insurance assets
				bys group : egen pondtemp=sum(pondn) if owner_avie==1
				replace rfin_av_cn_foy=share_avie/100*${revavieNA}*1000000000/pondtemp if  owner_avie==1
				replace patfin_av_cn_foy=share_avie/100*${patfin_avNA}*1000000000/pondtemp if owner_avie==1								
				drop pondtemp  pondvr  q_age_pr q_age_fin q_age_fin_lr group  owner_avie   p100  prop_avie  share_avie
				
	* II.B) Imputation of deposits and savings accounts	
	*****************************************************
		
		* 1) Variables used for imputations		
				
			* Age groups			
				capture drop q_age_pr
				gen q_age_pr = 1
				replace q_age_pr = 2 if age >30
				replace q_age_pr = 3 if age >39
				replace q_age_pr = 4 if age >49
				replace q_age_pr = 5 if age >54
				replace q_age_pr = 6 if age >60
				replace q_age_pr = 7 if age >65
				replace q_age_pr = 8 if age >70
		
			* Age.groups of financial income
				gen pondvr=round(100*pondn) 
				bys year q_age_pr : cumul rev_fin_irpp_foy [w=pondvr], gen (p100)
				replace p100=p100*100
				gen q_age_fin   = 0
				replace q_age_fin= 50   if p100 >=50 & p100 <75 & q_age_fin==0
				replace q_age_fin= 75   if p100 >=75 & p100 <90 & q_age_fin==0
				replace q_age_fin= 90   if p100 >=90 & p100 <95 & q_age_fin==0
				replace q_age_fin= 95   if p100 >=95  & q_age_fin==0
				drop p100 pondvr

			* Age.groups of financial income.groups of labor income.
				gen pondvr=round(100*pondn) 
				bys year q_age_pr q_age_fin : cumul rev_trav_irpp_foy [w=pondvr], gen (p100)
				gen p10=p100*100
				gen q_age_fin_lr  = 0
				replace q_age_fin_lr=25  if p10 >=25 & p10 <50 & q_age_fin_lr==0
				replace q_age_fin_lr= 50   if p10 >=50 & p10 <75 & q_age_fin_lr==0
				replace q_age_fin_lr= 75   if p10 >=75 & p10 <90 & q_age_fin_lr==0
				replace q_age_fin_lr= 90   if p10 >=90 & p10 <95 & q_age_fin_lr==0
				replace q_age_fin_lr= 95  if p10 >=95 & q_age_fin_lr==0
				drop p10 p100 pondvr 
				* Adjusment for the top 5% of financial income (not enough observation to split into labor income)
					replace q_age_fin_lr= 0   if q_age_fin== 95
	
		* 2) Merge imputations parameters of each groups
			if ${year}<1986 {
				tempfile temp
				save "`temp'"
				use "$param/Imputation/clef_liqu_EP.dta",clear
				keep if year==1986
				drop year
				tempfile cleftemp
				save "`cleftemp'",replace
				use "`temp'",clear
				merge m:1 q_age_pr q_age_fin q_age_fin_lr using "`cleftemp'"
				erase "`cleftemp'"
				erase "`temp'"
			}
			if ${year}>2010 {
				tempfile temp
				save "`temp'"
				use "$param/Imputation/clef_liqu_EP.dta",clear
				keep if year==2010
				drop year
				tempfile cleftemp
				save "`cleftemp'",replace
				use "`temp'",clear
				merge m:1 q_age_pr q_age_fin q_age_fin_lr using "`cleftemp'"
				erase "`cleftemp'"
				erase "`temp'"
			}
			if (${year}>=1986 & ${year}<=2010) {
				merge m:1 year q_age_pr q_age_fin q_age_fin_lr using "$param/Imputation/clef_liqu_EP.dta"
			}
			drop if _merge==2
			drop _merge
											
		* 3) Imputation of deposits and savings accounts
			gen group=10000*q_age_pr+100* q_age_fin +q_age_fin_lr
			gen rfin_liqu_cn_foy=0
			gen patfin_liqu_cn_foy=0
			* Everybody has a bank account
			gen owner_liq=1
			* But not everybody has savings accounts
			gen owner_liqurev=0					
			
			* Extensive margin: savings accounts
				sort idfoy
				gen pondvr=round(100*pondn) 
				bys group : gen uni_noncc=runiform() if owner_liq==1 
				sort group uni_noncc
				bys group : cumul uni_noncc [w=pondvr], gen (p100_noncc)	
				replace owner_liqurev=1 if prop_patfin_liqu_noncc>=p100_noncc										
				drop p100_noncc uni_noncc

			* Intensive margin					
				* Savings accounts and deposits	
					bys group : egen pondtemp=sum(pondn) if owner_liq==1
					replace patfin_liqu_cn_foy=share_patfin_liqu/100*${patfin_liquNA}*1000000000/pondtemp if owner_liq==1					
					drop pondtemp
				* Capital income from savings accounts
					quiet sum patfin_liqu_cn_foy [aw =pondn] if owner_liqurev==1
					replace rfin_liqu_cn_foy=patfin_liqu_cn_foy*${revliquNA}*1000000000/r(sum) if owner_liqurev==1

			drop pondvr owner_liqurev q_age_pr q_age_fin q_age_fin_lr group  owner_liq  prop_patfin_liqu_noncc prop_patfin_liqu  share_patfin_liqu
					
					
	* II.C) Imputation of owner-occupied housing assets	
	*****************************************************	
	
		* 1) Variables used for imputations	
		
			* Age groups			
				capture drop q_age_pr
				gen q_age_pr = 1
				replace q_age_pr = 2 if age >24
				replace q_age_pr = 3 if age >30
				replace q_age_pr = 4 if age >39
				replace q_age_pr = 5 if age >49
				replace q_age_pr = 6 if age >54
				replace q_age_pr = 7 if age >60
				replace q_age_pr = 8 if age >65
				replace q_age_pr = 9 if age >70
				replace q_age_pr = 10 if age >80
		
		if ${year}>=1992 {
		* Imputation using wealth surveys: age groups* groups of financial income*groups of labor income
			* Age groups*groups of financial income		
				sort year q_age_pr rev_fin_irpp_foy
				gen pondvr=round(100*pondn) 
				bys year pac q_age_pr : cumul rev_fin_irpp_foy [w=pondvr], gen (p100)
				replace p100=p100*100
				gen q_age_fin   = 0
				replace q_age_fin= 50   if p100 >=50 & p100 <90 & q_age_fin==0
				replace q_age_fin= 90   if p100 >=90 & p100 <99 & q_age_fin==0
				replace q_age_fin= 99   if p100 >=99 & q_age_fin==0
				drop p100 pondvr
				* Adjusment for < 30 years old (only 10% of housing ownership) => No distinction by financial income (they have almost nothing)
					replace q_age_fin=0 if q_age_pr==1 | q_age_pr==2
		
			* Age.groups of financial income.groups of labor income.
				sort year q_age_pr q_age_fin rev_trav_irpp_foy
				gen pondvr=round(100*pondn) 
				bys year pac q_age_pr q_age_fin : cumul rev_trav_irpp_foy [w=pondvr], gen (p100)
				replace p100=p100*100
				gen q_age_fin_lr  = 0
				replace q_age_fin_lr=25  if p100 >=25 & p100 <50 & q_age_fin_lr==0
				replace q_age_fin_lr= 50   if p100 >=50 & p100 <75 & q_age_fin_lr==0
				replace q_age_fin_lr= 75   if p100 >=75 & p100 <90 & q_age_fin_lr==0
				replace q_age_fin_lr= 90   if p100 >=90 & q_age_fin_lr==0
				drop p100 pondvr rev_fin_irpp_foy rev_trav_irpp_foy
				* Adjusment for the top 1% of financial income (not enough observation to split into labor income)
					replace q_age_fin_lr=0 if q_age_fin==99
		}
		if ${year}<1992 {
		* Imputation using housing surveys: age groups* groups of total income
	
			* Age groups			
				replace q_age_pr = 9 if q_age_pr==10
				* Adjustment of age groups because of missing values on "patfon_owner"
				replace q_age_pr=7 if inlist(q_age_pr,8,9) & year==1970
				replace q_age_pr=8 if inlist(q_age_pr,9) & year>1970 & year <=1973
				
			* Age groups*groups of total income		
				sort year pac q_age_pr rev_tot
				gen u=runiform() if rev_tot==0
				replace rev_tot=u if rev_tot==0
				
				gen pondvr=round(100*pondn) 
				bys year pac q_age_pr : cumul rev_tot [w=pondvr], gen (p100)
				replace p100=p100*100
				gen q_age_rev   = 0
				replace q_age_rev= 25   if p100 >=25 & p100 <50 & q_age_rev==0
				replace q_age_rev= 50   if p100 >=50 & p100 <75 & q_age_rev==0
				replace q_age_rev= 75   if p100 >=75 & p100 <90 & q_age_rev==0
				replace q_age_rev= 90   if p100 >=90 & p100 <95 & q_age_rev==0
				replace q_age_rev= 95   if p100 >=95 & p100 <99 & q_age_rev==0
				replace q_age_rev= 99   if p100 >=99 & q_age_rev==0
				drop p100 pondvr u
				* Adjustments
				* For less than 30 y.o : only 5% of homeowners => Need to agregate P95-99 and P99-100 into P95-100
				replace q_age_rev=95 if (q_age_pr<3) & (q_age_rev==95 | q_age_rev==99)
		}
		

		* 2) Merge imputations parameters of each groups
			* Use housing surveys from 1970 to 1992
			* Use wealth surveys since 1992
			if ${year}<1992 {
				merge m:1 year q_age_pr q_age_rev using "$param/Imputation/clef_immo_ENL.dta"
				gen group=10000*q_age_pr+q_age_rev
			}
			if ${year}>2010 {
				tempfile temp
				save "`temp'"
				use "$param/Imputation/clef_immo_EP.dta",clear
				keep if year==2010
				drop year
				tempfile cleftemp
				save "`cleftemp'",replace
				use "`temp'",clear
				merge m:1 q_age_pr q_age_fin q_age_fin_lr using "`cleftemp'"
				erase "`cleftemp'"
				erase "`temp'"
				gen group=10000*q_age_pr+100* q_age_fin +q_age_fin_lr
			}
			if (${year}>=1992 & ${year}<=2010) {
				merge m:1 year q_age_pr q_age_fin q_age_fin_lr using "$param/Imputation/clef_immo_EP.dta"
				gen group=10000*q_age_pr+100* q_age_fin +q_age_fin_lr
			}
			drop if _merge==2
			drop _merge
			
		* 3) Imputation of owner-occupied housing assets and corresponding debts		
			gen rfon_owner_cn_foy=0
			gen patfon_owner_brut_cn_foy=0
			gen patfon_owner_net_cn_foy=0
			gen passif_owner_cn_foy=0
			gen owner=0
			
			* Extensive margin: detention of owner-occupied housing assets
				sort idfoy
				bys pac group: gen uni=runiform()
				gen pondvr=round(100*pondn) 
				sort pac group uni
				bys pac group : cumul uni [w=pondvr], gen (p100)
				drop uni pondvr
				replace owner=1 if prop_immo>=p100	& pac==0							

			* Intensive margin: imptued rents, owner-occupied housing assets, debts	
				bys group : egen pondtemp=sum(pondn) if owner==1
				replace rfon_owner_cn_foy=share_patimmo/100*${revfon_fictifNA}*1000000000/pondtemp if   owner==1
				replace patfon_owner_brut_cn_foy=share_patimmo/100*${patfon_owner_brutNA}*1000000000/pondtemp if owner==1	
				replace passif_owner_cn_foy=ratio_pass_owner*patfon_owner_brut_cn_foy if owner==1							
				* Housing debts consistent with NA level
					quiet sum passif_owner_cn_foy [aw=pondn]
					gen ratio_temp=min(1,ratio_pass_owner*${passif_ownerNA}*1000000000/r(sum))
					replace passif_owner_cn_foy=ratio_temp*patfon_owner_brut_cn_foy
					* Adjustment if ratio_temp=1
					quiet sum passif_owner_cn_foy [aw=pondn] if ratio_temp>0.95
					local passif_max=r(sum)
					quiet sum passif_owner_cn_foy [aw=pondn] 
					local passif=r(sum)
					replace passif_owner_cn_foy=passif_owner_cn_foy*(${passif_ownerNA}*1000000000-`passif_max')/(`passif'-`passif_max') if ratio_temp<=0.95
				
				replace passif_owner_cn_foy= patfon_owner_brut_cn_foy if passif_owner_cn_foy>patfon_owner_brut_cn_foy
				replace patfon_owner_net_cn_foy=patfon_owner_brut_cn_foy-passif_owner_cn_foy
			drop q_age* group pondtemp owner p100 prop_immo share_patimmo ratio_temp ratio_pass_owner

* III) Capitalization method for assets that yield taxable income
********************************************************************
		
		* Tenant-owner housing assets
		*******************************
			quiet sum rfon_irpp_foy [aw=pondn]
			gen rfon_rent_cn_foy = rfon_irpp_foy*(${revfonNA}-${revfon_fictifNA})*1000000000/r(sum)
						
			gen patfon_rent_brut_cn_foy=rfon_irpp_foy*${patfon_rent_brutNA}/r(sum)*1000000000
			gen patfon_rent_net_cn_foy=rfon_irpp_foy*${patfon_rent_netNA}/r(sum)*1000000000
			gen passif_rent_cn_foy=rfon_irpp_foy*${passif_rentNA}/r(sum)*1000000000

			gen rfon_cn_foy=rfon_rent_cn_foy+rfon_owner_cn_foy
			gen patfon_brut_cn_foy=patfon_owner_brut_cn_foy+patfon_rent_brut_cn_foy
			gen patfon_net_cn_foy=patfon_owner_net_cn_foy+patfon_rent_net_cn_foy
			gen passif_cn_foy=passif_owner_cn_foy+passif_rent_cn_foy


		* Bonds and equities + mutual funds
		**************************************
			* For Period 1970-1984: Interest and dividends are reported together
			if ${year}<=1984 {
				quiet sum rfin_irpp_foy [aw=pondn]
				gen revfin_divint=rfin_irpp_foy*(${revdivNA}+${revintNA})/r(sum)*1000000000
				gen patfin_divint=rfin_irpp_foy*(${patfin_divNA}+${patfin_intNA})/r(sum)*1000000000
				
				* Simple decomposition between equities and bonds corresponding to their proportion at the macro level
					gen patfin_div_cn_foy=${patfin_divNA}/(${patfin_divNA}+${patfin_intNA})*patfin_divint
					gen patfin_int_cn_foy=${patfin_intNA}/(${patfin_divNA}+${patfin_intNA})*patfin_divint
					gen rfin_div_cn_foy=${revdivNA}/(${revdivNA}+${revintNA})*revfin_divint
					gen rfin_int_cn_foy=${revintNA}/(${revdivNA}+${revintNA})*revfin_divint

				foreach var of varlist patfin_div_cn_foy patfin_int_cn_foy rfin_int_cn_foy rfin_div_cn_foy {
					replace `var'=0 if `var'==.
				}
				drop patfin_divint revfin_divint
			}
			
			* For Period > 1984: 
				* Interest and dividends are reported separately	but we capitalize them together for comparability issues
				* See robustness checks for separate capitalization of bonds and equities
			if ${year}>1984 {			
				gen temp=rfin_div_irpp_foy+rfin_int_irpp_foy
				quiet sum temp [aw=pondn]
				gen revfin_divint=temp*(${revdivNA}+${revintNA})/r(sum)*1000000000
				gen patfin_divint=temp*(${patfin_divNA}+${patfin_intNA})/r(sum)*1000000000
				
				* Decomposition between equities and bondss
					* Simple case: Individuals have only interests or only dividends
					gen patfin_int_cn_foy=patfin_divint if rfin_int_irpp_foy==temp
					replace patfin_int_cn_foy=0	if rfin_div_irpp_foy==temp
					gen patfin_div_cn_foy=patfin_divint if rfin_div_irpp_foy==temp
					replace patfin_div_cn_foy=0	if rfin_int_irpp_foy==temp
					
					* Individuals have both interests and dividends
						quiet sum rfin_div_irpp_foy [aw=pondn]
						local ratediv=r(sum)/(${patfin_divNA}*1000000000)
						quiet sum rfin_int_irpp_foy [aw=pondn]
						local rateint=r(sum)/(${patfin_intNA}*1000000000)
						
						if `rateint'<=`ratediv' {
							quiet sum rfin_div_irpp_foy if rfin_div_irpp_foy<temp [aw=pondn]
							local totdiv=r(sum)
							quiet sum  patfin_div_cn_foy if rfin_div_irpp_foy==temp [aw=pondn]
							local patfin_div_exl =r(sum)
							replace patfin_div_cn_foy=min(patfin_divint,rfin_div_irpp_foy/`totdiv'*(${patfin_divNA}*1000000000-`patfin_div_exl')) if rfin_div_irpp_foy<temp				
							replace patfin_int_cn_foy=patfin_divint-patfin_div_cn_foy
						}
						if `rateint'>`ratediv' {
							quiet sum rfin_int_irpp_foy if rfin_int_irpp_foy<temp [aw=pondn]
							local totint=r(sum)
							quiet sum  patfin_int_cn_foy if rfin_int_irpp_foy==temp [aw=pondn]
							local patfin_int_exl =r(sum)
							replace patfin_int_cn_foy=min(patfin_divint,rfin_int_irpp_foy/`totint'*(${patfin_intNA}*1000000000-`patfin_int_exl')) if rfin_int_irpp_foy<temp				
							replace patfin_div_cn_foy=patfin_divint-patfin_int_cn_foy
						}
					* Financial income
						quiet sum  patfin_int_cn_foy  [aw=pondn]
						gen rfin_int_cn_foy=patfin_int_cn_foy*${revintNA}*1000000000/r(sum)
						quiet sum  patfin_div_cn_foy  [aw=pondn]
						gen rfin_div_cn_foy=patfin_div_cn_foy*${revdivNA}*1000000000/r(sum)
					
					drop temp patfin_divint revfin_divint
			}
			
			
		* Business assets
		*******************
			quiet sum nonsal_capital_cn_foy [aw=pondn]
			gen patpro_cn_foy=nonsal_capital_cn_foy*${patproNA}/r(sum)*1000000000
					
			
	gen rcap_cn_foy=nonsal_capital_cn_foy+rfon_cn_foy+rfin_div_cn_foy+rfin_int_cn_foy+rfin_av_cn_foy+rfin_liqu_cn_foy
	gen pat_cn_foy=patfon_net_cn_foy+patfin_av_cn_foy+patfin_div_cn_foy+patfin_int_cn_foy+patpro_cn_foy+patfin_liqu_cn_foy
	gen patfin_cn_foy=patfin_av_cn_foy+patfin_div_cn_foy+patfin_int_cn_foy+patfin_liqu_cn_foy
	
	keep idfoy *_cn_foy share_patfin_liqu_pac
	merge 1:m idfoy using "`table'" 
	erase "`table'"
		
*****************************************************************************
* IV) Individualization of wealth and capital income and last adjustments   *
*****************************************************************************
		
	* Individualization of capital income and wealth among couples: Divide by 2
		foreach var of varlist *_cn_foy {
			replace `var'=`var'/2 if ndecl==2 & pac==0
			replace `var'=0 if pac==1 & idnum~=1
		}
	* Deposits and savings accounts of dependents (pac=1)
		bys idfoy : egen liqu=sum(patfin_liqu_cn)
		bys idfoy : egen rliqu=sum(rfin_liqu_cn)
		gen npac=ntot-ndecl
		replace patfin_liqu_cn=share_patfin_liqu_pac*liqu/npac if pac==1 & idnum~=1
		replace patfin_liqu_cn=patfin_liqu_cn-share_patfin_liqu_pac*liqu/ndecl if npac>0  & pac==0
		replace rfin_liqu_cn=rliqu/liqu*patfin_liqu_cn if pac==1 & idnum~=1
		replace rfin_liqu_cn=rfin_liqu_cn*(1-share_patfin_liqu_pac/ndecl) if npac>0  & pac==0
				
	drop *_irpp_foy _merge share_patfin_liqu_pac liqu rliqu npac rev_tot
	foreach var of newlist pat_cn patfon_owner_brut_cn patfon_owner_net_cn patfon_rent_brut_cn patfon_rent_net_cn patfon_brut_cn patfon_net_cn  passif_cn passif_owner_cn passif_rent_cn patpro_cn	patfin_cn	patfin_div_cn	patfin_int_cn	patfin_liqu_cn	patfin_av_cn rcap_cn rfon_cn rfon_owner_cn rfon_rent_cn nonsal_capital_cn rfin_div_cn rfin_int_cn rfin_liqu_cn rfin_av_cn {
		rename `var'_foy `var'
	}
	* Rounding errors and check
		foreach var of newlist patfon_owner_brut passif_owner patfon_rent_brut passif_rent patfin_int patfin_div patpro patfin_liqu patfin_av {
			quiet sum `var'_cn [aw=pondn]
			dis r(sum)/${`var'NA}/1000000000
			replace `var'_cn=`var'_cn*${`var'NA}*1000000000/r(sum)
		}
		
		
	* Supplemental variables needed
		replace patfon_brut_cn=patfon_owner_brut_cn+patfon_rent_brut_cn
		replace passif_cn=passif_owner_cn+passif_rent_cn
		replace patfon_owner_net_cn=patfon_owner_brut_cn-passif_owner_cn
		replace patfon_rent_net_cn=patfon_rent_brut_cn-passif_rent_cn
		replace patfon_net_cn=patfon_owner_net_cn+patfon_rent_net_cn
		replace patfin_cn=patfin_av_cn+patfin_div_cn+patfin_int_cn+patfin_liqu_cn
		replace rcap_cn=nonsal_capital_cn+rfon_cn+rfin_div_cn+rfin_int_cn+rfin_av_cn+rfin_liqu_cn
		replace pat_cn=patfon_net_cn+patfin_av_cn+patfin_div_cn+patfin_int_cn+patpro_cn+patfin_liqu_cn
		gen factorcapital=${factorcapital}

		
	sort idfoy idnum		
	#delimit;
			order year idfoy idnum idindiv pondn ntot ndecl pac age 
			pat_cn	patfon_net_cn	patfon_owner_net_cn	patfon_rent_net_cn	patpro_cn	
			patfin_cn	patfin_div_cn	patfin_int_cn	patfin_liqu_cn	patfin_av_cn
			patfon_brut_cn patfon_owner_brut_cn patfon_rent_brut_cn passif_cn passif_owner_cn passif_rent_cn
			rcap_cn rfon_cn rfon_owner_cn rfon_rent_cn nonsal_capital_cn 
			rfin_div_cn rfin_int_cn rfin_liqu_cn rfin_av_cn factorcapital  ;
	#delimit cr
	
	
	save "$wfrevcapwealthcn/revcapwealthcn${year}.dta",replace	
		
	macro drop passif_rentNA passif_ownerNA patfon_rent_brutNA patfon_owner_brutNA revfon_fictifNA revavieNA revfonNA revdivNA revliquNA revintNA patproNA patfin_intNA patfin_divNA patfin_avNA patfon_rent_netNA patfon_owner_netNA patfin_liquNA       

}


